//
//  ICFAssetGroupViewController.h
//  Asset Library Navigator
//
//  Created by Joe Keeley on 4/15/12.
//  Copyright (c) 2012 Explore Systems, Inc. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AssetsLibrary/AssetsLibrary.h>

@interface ICFAssetGroupViewController : UIViewController <UITableViewDataSource, UITableViewDelegate, UIImagePickerControllerDelegate, UINavigationControllerDelegate>

@property (nonatomic, retain) NSMutableArray *assetArray;
@property (nonatomic, retain) NSURL *assetGroupURL;
@property (nonatomic, retain) NSString *assetGroupName;
@property (nonatomic, retain) IBOutlet UITableView *assetTableView;
@property (nonatomic, retain) IBOutlet UIBarButtonItem *addButton;
@property (nonatomic, retain) ALAssetsLibrary *assetsLibrary;

- (IBAction)addButtonTouched:(id)sender;
- (void)image:(UIImage *) image didFinishSavingWithError: (NSError *) error contextInfo: (void *) contextInfo;
@end
